/**
 * Class to represent all translations of one language imported from XML file
 */
export class Lexicon {
	/**
	 * Constructor
	 * @param {jQuery} xmlObject	Data loaded from XML - all Lexicons (all languages)
	 * @param {String} language 	Chosen language name
	 */
	constructor(xmlObject, language) {
		this.lexiconMarkups = $(xmlObject).find(language)[0].children;
	}
	
	/**
	 * Gets text from Lexicon in configured language for chosen HTML markup name, additionaly it replaces some texts if searchValueX and replaceValueX arguments are defined (it is special functionality for warning texts in DialogWindow)
	 * @param {String} markupName 		Name of HTML markup, which is defined in Lexicon
	 * @param {String} searchValue1 	First searchValue of String.replace() method
	 * @param {String} replaceValue1 	First replaceValue of String.replace() method
	 * @param {String} searchValue2 	Second searchValue of String.replace() method
	 * @param {String} replaceValue2 	Second replaceValue of String.replace() method
	 * @returns 
	 */
	getLexiconMarkupText(markupName, searchValue1, replaceValue1, searchValue2, replaceValue2) {
		var result = "";
		for (var i = 0; i < this.lexiconMarkups.length; i++) {
			if(this.lexiconMarkups[i].localName == markupName.toLowerCase()) {
				result = this.lexiconMarkups[i].innerHTML;
				if(searchValue1 != undefined && replaceValue1 != undefined) {
					result = result.replace(searchValue1, replaceValue1);
					if(searchValue2 != undefined && replaceValue2 != undefined) {
						result = result.replace(searchValue2, replaceValue2);
					}
				}
				break;
			}
		}
		return result;
	}
}